/*
	File:		FinderWindow.h

	Contains:	Finder window simulation using the Appearance Manager.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

#ifndef _FINDERWINDOW_H
#define _FINDERWINDOW_H

#include <Controls.h>
#include "BaseWindow.h"
#include "Appearance.h"

class FinderWindow : public BaseWindow
{
	public:
			FinderWindow();
		virtual ~FinderWindow();
		
		virtual void		Activate( EventRecord& event );
		virtual void		Deactivate( EventRecord& event );
		virtual void		Draw();
		virtual void		Resize( SInt16 width, SInt16 height );
		virtual void		HandleClick( EventRecord& event );
		
	private:
		virtual void		DrawPlacard( ThemeDrawState state, Boolean validate );
		virtual void		GetContentRect( Rect& rect );
		virtual void		InvalidateScrollBars();
		virtual void		InvalidatePlacard();
		virtual void		CalcHorizScrollBarRect( Rect& rect );
		virtual void		CalcVertScrollBarRect( Rect& rect );
	
		static pascal void	ScrollBarAction( ControlHandle control, SInt16 partHit );
		static pascal void	DrawListView( SInt16 depth, SInt16 flags, GDHandle device, long userData );

		ControlHandle		fHorizScrollBar;
		ControlHandle		fVertScrollBar;
};

#endif // _FINDERWINDOW_H
